package coreservlets;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet obsuguje dane przesane z formularza zamwienia.
 *  Jeeli uytkownik nacinie przycisk "Rezerwuj towar",
 *  wybrany towar zostanie zapisany w atrybucie orderedItem.
 *  Jeeli uytkownik nacinie przycisk "Anuluj zamwienie",
 *  atrybut orderedItem zostanie usunity.
 *  Jeeli uytkownik nacinie przycisk "Kupuj towar",
 *  wybrany towar zostanie przypisany atrybutowi purchasedItem.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class OrderHandlingServlet extends HttpServlet {
  private String title, picture;
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    HttpSession session = request.getSession(true);
    String itemName = request.getParameter("itemName");
    if ((itemName == null) || (itemName.equals(""))) {
      itemName = "<B>BRAK TOWARU</B>";
    }
    String message;
    if (request.getParameter("order") != null) {
      session.setAttribute("orderedItem", itemName);
      message = "Dzikujemy, e zamwie " + itemName + ".";
    } else if (request.getParameter("cancel") != null) {
      session.removeAttribute("orderedItem");
      message = "Dzikujemy mimo wszystko.";
    } else {
      session.setAttribute("purchasedItem", itemName);
      message = "Dzikujemy, e zakupie " + itemName + ".";
    }
    response.setCharacterEncoding("UTF-8");            response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println
      (docType +
       "<HTML>\n" +
       "<HEAD><TITLE>" + message + "</TITLE></HEAD>\n" +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H2 ALIGN=\"CENTER\">" + message + "</H2>\n" +
       "</BODY></HTML>");
  }
}
